<?php
/* --------------------------------------------------------------
   dependent.inc.php 2022-08-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------*/

/** @var DatabaseModel $this */
/** @var bool $t_success */

$check = $this->query('SELECT `value` FROM `gx_configurations` WHERE `key` = "gm_configuration/SERVICE_WITHOUT_SHIPPING"',
                      true);

if ($check->num_rows < 1) {
    $query     = 'INSERT INTO `gx_configurations` SET `key` = "gm_configuration/SERVICE_WITHOUT_SHIPPING", `value` = "false", `default` = "false", `type` = "switcher", `sort_order` = 0';
    $t_success &= $this->query($query, true);
}

// removing skrill from list of installed payment modules
$installedPaymentModules = $this->getConfiguration('MODULE_PAYMENT_INSTALLED');
$installedPaymentModules = explode(';', $installedPaymentModules);
$installedPaymentModules = array_filter($installedPaymentModules, static function(string $module): bool {
    return preg_match('/^skrill/', $module) !== 1;
});
$installedPaymentModules = implode(';', $installedPaymentModules);
$this->replaceConfiguration('MODULE_PAYMENT_INSTALLED', $installedPaymentModules);

// adding missing entries to product_image_list_image_text table
$query = <<<SQL
INSERT INTO `product_image_list_image_text`
(
    `product_image_list_image_id`,
    `product_image_list_image_text_type`,
    `product_image_list_image_text_value`,
    `language_id`
)
SELECT
       `i`.`product_image_list_image_id`,
       `it`.`product_image_list_image_text_type` as 'type',
       'Product image' AS 'title',
       `l`.`languages_id`
FROM product_image_list_image AS `i`
JOIN `languages` `l` ON 1
JOIN `product_image_list_image_text` AS `it`
ON `it`.`language_id` = `l`.`languages_id` AND `it`.`product_image_list_image_id`= (
    SELECT `product_image_list_image_id` FROM `product_image_list_image_text` LIMIT 1
)
WHERE `i`.`product_image_list_image_id` NOT IN (
    SELECT DISTINCT `i`.`product_image_list_image_id`
    FROM product_image_list_image AS `i`
    INNER JOIN product_image_list_image_text AS `it`
    ON `i`.`product_image_list_image_id` = `it`.`product_image_list_image_id`
)
SQL;
$t_success &= $this->query($query, true);

// overwriting german default titles
$query = <<<SQL
UPDATE `product_image_list_image_text` AS `text` SET `text`.`product_image_list_image_text_value` = 'Artikelbild'
WHERE `text`.`product_image_list_image_text_value` = 'Product image' AND `language_id`=2
SQL;
$t_success &= $this->query($query, true);

// Checks if the "display confirmation email" settings is already in the `gx_configurations` table
$check = $this->query('SELECT `value` FROM `gx_configurations` WHERE `key` = "configuration/ACCOUNT_CONFIRMATION_EMAIL"',
                      true);
if ($check->num_rows < 1) {
    $query     = 'INSERT INTO `gx_configurations` SET `key` = "configuration/ACCOUNT_CONFIRMATION_EMAIL", `value` = "true", `default` = "true", `type` = "switcher", `sort_order` = 2';
    $t_success &= $this->query($query, true);
}